//LLAMA2-13B DATASET v1.0 Category: Searching algorithm ; Style: accurate
#include <stdio.h>
#include <stdlib.h>

#define MAX_SIZE 1000

// Structure to store the data
typedef struct {
    int key;
    int value;
} data_t;

// Function to search an element in the array
int search(data_t arr[], int key) {
    int low = 0, high = MAX_SIZE - 1;

    // Search the element in the middle of the array
    while (low <= high) {
        int mid = (low + high) / 2;
        if (arr[mid].key == key) {
            return mid;
        }

        // If the element is less than the key, move the low index to the mid-1
        if (arr[mid].key < key) {
            low = mid + 1;
        }

        // If the element is greater than the key, move the high index to the mid-1
        else {
            high = mid - 1;
        }
    }

    return -1; // Not found
}

int main() {
    data_t arr[MAX_SIZE] = {
        {1, 1},
        {2, 2},
        {3, 3},
        {4, 4},
        {5, 5}
    };

    int key = 3;
    int index = search(arr, key);

    if (index != -1) {
        printf("Found %d at index %d\n", key, index);
    } else {
        printf("Not found\n");
    }

    return 0;
}