//GEMINI-pro DATASET v1.0 Category: File system simulation ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct inode {
    char name[32];
    int size;
    int blocks[10];
};

struct directory {
    struct inode inodes[10];
    int num_inodes;
};

struct file_system {
    struct directory root;
};

struct file_system fs;

void create_file(char *name, int size) {
    struct inode *inode = &fs.root.inodes[fs.root.num_inodes++];
    strcpy(inode->name, name);
    inode->size = size;
    for (int i = 0; i < 10; i++) {
        inode->blocks[i] = -1;
    }
}

void delete_file(char *name) {
    for (int i = 0; i < fs.root.num_inodes; i++) {
        if (strcmp(fs.root.inodes[i].name, name) == 0) {
            for (int j = 0; j < 10; j++) {
                if (fs.root.inodes[i].blocks[j] != -1) {
                    free(fs.root.inodes[i].blocks[j]);
                }
            }
            fs.root.inodes[i] = fs.root.inodes[fs.root.num_inodes - 1];
            fs.root.num_inodes--;
            break;
        }
    }
}

void list_files() {
    for (int i = 0; i < fs.root.num_inodes; i++) {
        printf("%s\n", fs.root.inodes[i].name);
    }
}

int main() {
    create_file("file1.txt", 100);
    create_file("file2.txt", 200);
    create_file("file3.txt", 300);
    list_files();
    delete_file("file2.txt");
    list_files();
    return 0;
}