//Falcon2-11B DATASET v1.0 Category: Sorting ; Style: decentralized
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

// Function to swap two elements in the array
void swap(int* arr, int i, int j) {
    int temp = arr[i];
    arr[i] = arr[j];
    arr[j] = temp;
}

// Function to check if an element should be swapped with its adjacent element
bool shouldSwap(int* arr, int i, int j) {
    int temp = arr[i];
    int temp2 = arr[i+1];
    if (temp > temp2) {
        return true;
    } else {
        return false;
    }
}

// Function to sort the array using the bubble sort algorithm
void bubbleSort(int* arr, int size) {
    for (int i = 0; i < size - 1; i++) {
        for (int j = 0; j < size - i - 1; j++) {
            if (shouldSwap(arr, j, j+1)) {
                swap(arr, j, j+1);
            }
        }
    }
}

// Function to print the sorted array
void printArray(int* arr, int size) {
    for (int i = 0; i < size; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}

int main() {
    int arr[] = {10, 5, 8, 3, 2, 1};
    int size = sizeof(arr) / sizeof(arr[0]);

    bubbleSort(arr, size);

    printf("Sorted array: ");
    printArray(arr, size);

    return 0;
}