//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SIZE 100

typedef struct {
    char name[MAX_SIZE];
    int quantity;
    float price;
} Item;

typedef struct {
    char name[MAX_SIZE];
    int capacity;
    int num_items;
    Item items[MAX_SIZE];
} Warehouse;

void init_warehouse(Warehouse* wh) {
    wh->num_items = 0;
    wh->capacity = MAX_SIZE;
}

void add_item(Warehouse* wh, char* name, int quantity, float price) {
    if (wh->num_items >= wh->capacity) {
        printf("Warehouse is full. Cannot add item.\n");
        return;
    }

    Item new_item;
    strcpy(new_item.name, name);
    new_item.quantity = quantity;
    new_item.price = price;

    wh->items[wh->num_items] = new_item;
    wh->num_items++;
}

void display_items(Warehouse* wh) {
    printf("Items in the warehouse:\n");
    for (int i = 0; i < wh->num_items; i++) {
        printf("%s: %d units at %.2f gold coins each\n", wh->items[i].name, wh->items[i].quantity, wh->items[i].price);
    }
}

int main() {
    Warehouse my_warehouse;
    init_warehouse(&my_warehouse);

    add_item(&my_warehouse, "Swords", 50, 10.0);
    add_item(&my_warehouse, "Shields", 30, 5.0);
    add_item(&my_warehouse, "Armor", 20, 20.0);

    display_items(&my_warehouse);

    return 0;
}