//Falcon-180B DATASET v1.0 Category: Packet Capturer with pcap library ; Style: mind-bending
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <string.h>
#include <errno.h>
#include <time.h>

#define MAX_PACKET_SIZE 65536
#define SNAPLEN 65535

typedef struct {
    u_char *data;
    int len;
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    Packet *pkt = (Packet *) args;
    pkt->data = (u_char *) malloc(header->len);
    if (pkt->data == NULL) {
        fprintf(stderr, "Error: Could not allocate memory for packet data\n");
        exit(1);
    }
    memcpy(pkt->data, packet, header->len);
    pkt->len = header->len;
}

int main(int argc, char *argv[]) {
    char *dev = "eth0";
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    Packet packet;

    if (argc < 2) {
        fprintf(stderr, "Error: Please specify a capture device\n");
        exit(1);
    }

    if (pcap_lookupnet(dev, &packet.data, &packet.len, errbuf) == -1) {
        fprintf(stderr, "Error: Could not get network information for device %s: %s\n", dev, errbuf);
        exit(1);
    }

    handle = pcap_open_live(dev, SNAPLEN, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Error: Could not open capture device %s: %s\n", dev, errbuf);
        exit(1);
    }

    packet.data = NULL;
    packet.len = 0;

    pcap_loop(handle, -1, process_packet, (u_char *) &packet);

    pcap_freecode(&packet);
    pcap_close(handle);

    return 0;
}