//GPT-4o-mini DATASET v1.0 Category: Data recovery tool ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define FILENAME_LENGTH 50
#define RECOVERED_FILES 10

typedef struct {
    char name[FILENAME_LENGTH];
    int is_recovered;
} File;

void blemishedData(FILE *disk) {
    if (!disk) {
        printf("Oh sweet Juliet, thou art lost!\n");
        exit(EXIT_FAILURE);
    }
}

void unveilFiles(File *lostFiles, int count) {
    printf("Oh fair Verona, I present the lost treasures:\n");
    for (int i = 0; i < count; i++) {
        if (lostFiles[i].is_recovered) {
            printf("Recovered File: %s\n", lostFiles[i].name);
        }
    }
}

void recoverFile(File *file) {
    FILE *recovered = fopen(file->name, "w");
    if (recovered) {
        fprintf(recovered, "Data of the beloved %s!\n", file->name);
        fclose(recovered);
        file->is_recovered = 1;
        printf("Alas! The precious file %s hath been recovered!\n", file->name);
    } else {
        printf("Oh, cruel fate! I cannot recover %s!\n", file->name);
    }
}

void recoverLostFiles(File *lostFiles, int count) {
    for (int i = 0; i < count; i++) {
        recoverFile(&lostFiles[i]);
    }
}

int main(int argc, char *argv[]) {
    printf("Oh, what light through yonder window breaks?\n");
    if (argc < 2) {
        printf("Use: %s <disk_image>\n", argv[0]);
        return EXIT_FAILURE;
    }

    FILE *disk = fopen(argv[1], "rb");
    blemishedData(disk);

    File lostFiles[RECOVERED_FILES] = {
        {"Juliet_Love_Letter.txt", 0},
        {"My_Romeo_Sonnet.txt", 0},
        {"Capulet_Ball.dat", 0},
        {"Montague_Honor.dat", 0},
        {"Verona_Skies.txt", 0},
        {"Fateful_Night.log", 0},
        {"Secret_Plan.doc", 0},
        {"StarCrossed_Friends.jpg", 0},
        {"Heartfelt_Memories.png", 0},
        {"Eternal_Love.mp3", 0}
    };

    int totalLost = RECOVERED_FILES;

    printf("A tale of lost files, we now shall take...\n");
    recoverLostFiles(lostFiles, totalLost);
    unveilFiles(lostFiles, totalLost);

    fclose(disk);
    return EXIT_SUCCESS;
}