//GEMINI-pro DATASET v1.0 Category: Simple HTTP Proxy ; Style: artistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define MAX_BUFFER_SIZE 1024

// Paints the canvas with hues of welcome
void welcome_banner() {
    printf("\n\t\t\t   .::::::::::::.                      .::::::::::::.\n");
    printf("\t\t\t  .::::.   ..:::.                    .::::.   ..:::.  \n");
    printf("\t\t\t .:::...  .::::. ..::::::.   .::::::. .::::.  ...:::.  \n");
    printf("\t\t\t':::::.  .::::' .::::::::::. :::::::::. '::::.  .:::::'\n");
    printf("\t\t\t::::::::.::::::.: :::::::::::. :::::::::::.::::::.::::::::\n");
    printf("\t\t\t::::::::..:::::..' .::::::... .::::::. ..:::..::::::::\n");
    printf("\t\t\t.:::::::'    ''''   .::::::.   .::::::.   ''''    '::::::.\n");
    printf("\t\t\t.::::::.             .::::::.   .::::::.             .::::::.\n");
    printf("\t\t\t.::::::.             .::::::.   .::::::.             .::::::.\n");
    printf("\t\t\t.::::::.             .::::::.   .::::::.             .::::::.\n");
    printf("\t\t\t.::::::.             .::::::.   .::::::.             .::::::.\n");
    printf("\t\t\t.::::::.             .::::::'   '::::::.             .::::::.\n");
    printf("\t\t\t.::::::.             .::::::.     .::::::.            .::::::.\n");
    printf("\t\t\t .::::'               ':::.        .:::.               '::::. \n");
    printf("\t\t\t   ''''                    '         '                    ''' \n");
    printf("\n\t\t\t\t   A Simple HTTP Proxy   \n\n");
}

// Embellishes the canvas with user options
void print_usage() {
    printf("Usage: ./http-proxy [options]\n");
    printf("Options:\n");
    printf("  -p, --port <port>     Port to listen on (default: 8080)\n");
    printf("  -h, --help            Display this help message\n");
}

// Crafts the socket, a conduit for communication
int create_server_socket(int port) {
    int server_socket;

    // Solicits an internet socket, a pathway for communication
    server_socket = socket(AF_INET, SOCK_STREAM, 0);

    // Checks if the socket's creation was successful
    if (server_socket == -1) {
        perror("Failed to create server socket");
        exit(EXIT_FAILURE);
    }

    struct sockaddr_in server_address;

    // Prepares the server's address, a digital abode
    server_address.sin_family = AF_INET;
    server_address.sin_addr.s_addr = INADDR_ANY;
    server_address.sin_port = htons(port);

    // Binds the server socket to the server's address, establishing a connection
    if (bind(server_socket, (struct sockaddr *) &server_address, sizeof(server_address)) == -1) {
        perror("Failed to bind server socket to address");
        exit(EXIT_FAILURE);
    }

    // Listens for incoming connections, like a patient receptionist
    if (listen(server_socket, 10) == -1) {
        perror("Failed to listen on server socket");
        exit(EXIT_FAILURE);
    }

    return server_socket;
}

// Fetches the requested resource from the internet
int forward_request(int client_socket, char *request) {
    // Parses the request to extract the hostname and path
    char hostname[MAX_BUFFER_SIZE];
    char path[MAX_BUFFER_SIZE];
    sscanf(request, "GET %s HTTP/1.1", path);
    sscanf(path, "https://%[^/]%s", hostname, path);

    // Creates a socket to connect to the remote server
    int remote_socket;
    remote_socket = socket(AF_INET, SOCK_STREAM, 0);

    // Checks if the remote socket was created successfully
    if (remote_socket == -1) {
        perror("Failed to create remote socket");
        return -1;
    }

    struct sockaddr_in remote_address;

    // Prepares the remote server's address
    remote_address.sin_family = AF_INET;
    remote_address.sin_addr.s_addr = inet_addr(hostname);
    remote_address.sin_port = htons(80);

    // Connects to the remote server
    if (connect(remote_socket, (struct sockaddr *) &remote_address, sizeof(remote_address)) == -1) {
        perror("Failed to connect to remote server");
        return -1;
    }

    // Forwards the request to the remote server
    send(remote_socket, request, strlen(request), 0);

    // Receives the response from the remote server
    char response[MAX_BUFFER_SIZE];
    recv(remote_socket, response, sizeof(response), 0);

    // Forwards the response to the client
    send(client_socket, response, strlen(response), 0);

    // Closes the remote socket
    close(remote_socket);

    return 0;
}

int main(int argc, char **argv) {
    // Paints the welcome banner
    welcome_banner();

    // Parses the command line arguments
    int port = 8080;
    int opt;
    while ((opt = getopt(argc, argv, "p:h")) != -1) {
        switch (opt) {
            case 'p':
                port = atoi(optarg);
                break;
            case 'h':
                print_usage();
                exit(EXIT_SUCCESS);
            default:
                print_usage();
                exit(EXIT_FAILURE);
        }
    }

    // Creates the server socket
    int server_socket = create_server_socket(port);

    // Loops forever, handling incoming client connections
    while (1) {
        // Accepts an incoming connection, like a welcoming host
        int client_socket;
        client_socket = accept(server_socket, NULL, NULL);

        // Checks if the client socket was accepted successfully
        if (client_socket == -1) {
            perror("Failed to accept client connection");
            continue;
        }

        // Receives the request from the client
        char request[MAX_BUFFER_SIZE];
        recv(client_socket, request, sizeof(request), 0);

        // Forwards the request to the remote server
        int result = forward_request(client_socket, request);

        // Checks if the request was forwarded successfully
        if (result == -1) {
            perror("Failed to forward request");
        }

        // Closes the client socket
        close(client_socket);
    }

    // Closes the server socket
    close(server_socket);

    return 0;
}