//GEMINI-pro DATASET v1.0 Category: System process viewer ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/syscall.h>

int main() {
  // Define the system call number for getpid()
  const int GETPID_SYSCALL = 39;

  // Define the argument for getpid()
  const int NO_ARGS = 0;

  // Get the current process ID
  long pid = syscall(GETPID_SYSCALL, NO_ARGS);

  // Print the process ID
  printf("The current process ID is: %ld\n", pid);

  // Define the system call number for getppid()
  const int GETPPID_SYSCALL = 40;

  // Get the parent process ID
  long ppid = syscall(GETPPID_SYSCALL, NO_ARGS);

  // Print the parent process ID
  printf("The parent process ID is: %ld\n", ppid);

  // Define the system call number for getuid()
  const int GETUID_SYSCALL = 24;

  // Get the user ID
  long uid = syscall(GETUID_SYSCALL, NO_ARGS);

  // Print the user ID
  printf("The user ID is: %ld\n", uid);

  // Define the system call number for geteuid()
  const int GETEUID_SYSCALL = 72;

  // Get the effective user ID
  long euid = syscall(GETEUID_SYSCALL, NO_ARGS);

  // Print the effective user ID
  printf("The effective user ID is: %ld\n", euid);

  // Define the system call number for getgid()
  const int GETGID_SYSCALL = 47;

  // Get the group ID
  long gid = syscall(GETGID_SYSCALL, NO_ARGS);

  // Print the group ID
  printf("The group ID is: %ld\n", gid);

  // Define the system call number for getegid()
  const int GETEGID_SYSCALL = 74;

  // Get the effective group ID
  long egid = syscall(GETEGID_SYSCALL, NO_ARGS);

  // Print the effective group ID
  printf("The effective group ID is: %ld\n", egid);

  return 0;
}