//GEMINI-pro DATASET v1.0 Category: Drone Remote Control ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_DRONES 100
#define MAX_NAME_LENGTH 32

typedef struct {
    char name[MAX_NAME_LENGTH];
    int x;
    int y;
    int z;
} drone;

drone drones[MAX_DRONES];
int num_drones = 0;

void add_drone(char *name, int x, int y, int z) {
    if (num_drones == MAX_DRONES) {
        printf("Too many drones! Can't add %s.\n", name);
        return;
    }

    strcpy(drones[num_drones].name, name);
    drones[num_drones].x = x;
    drones[num_drones].y = y;
    drones[num_drones].z = z;

    num_drones++;
}

void print_drones() {
    for (int i = 0; i < num_drones; i++) {
        printf("%s: (%d, %d, %d)\n", drones[i].name, drones[i].x, drones[i].y, drones[i].z);
    }
}

void move_drone(char *name, int dx, int dy, int dz) {
    for (int i = 0; i < num_drones; i++) {
        if (strcmp(drones[i].name, name) == 0) {
            drones[i].x += dx;
            drones[i].y += dy;
            drones[i].z += dz;

            printf("%s moved to (%d, %d, %d).\n", name, drones[i].x, drones[i].y, drones[i].z);
            return;
        }
    }

    printf("Drone %s not found.\n", name);
}

int main() {
    add_drone("Buzz", 0, 0, 0);
    add_drone("Woody", 10, 10, 10);
    add_drone("Jessie", 20, 20, 20);

    print_drones();

    move_drone("Buzz", 5, 5, 5);
    move_drone("Woody", -5, -5, -5);
    move_drone("Jessie", 10, 10, 10);

    print_drones();

    return 0;
}