//MISTRAL-7B DATASET v1.0 Category: Percolation Simulator ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <time.h>

#define SITE_NUM 100
#define GRID_SIZE SITE_NUM
#define BOARD_SIZE (GRID_SIZE * GRID_SIZE)

typedef struct {
    int x, y;
} point;

int board[GRID_SIZE][GRID_SIZE];
bool visited[GRID_SIZE][GRID_SIZE];
point stack[GRID_SIZE * GRID_SIZE];
int top = 0;

void print_board() {
    int i, j;

    printf("\n");
    for (i = 0; i < GRID_SIZE; i++) {
        for (j = 0; j < GRID_SIZE; j++) {
            printf("%d ", board[i][j]);
        }
        printf("\n");
    }
}

bool is_valid_move(int x, int y) {
    if (x < 0 || x >= GRID_SIZE || y < 0 || y >= GRID_SIZE)
        return false;
    if (visited[x][y] || board[x][y] == 0)
        return false;
    return true;
}

void push(int x, int y) {
    stack[top++] = (point){x, y};
}

point pop() {
    return stack[--top];
}

void flood_fill(int x, int y) {
    point current;
    int dx[4] = {-1, 0, 1, 0};
    int dy[4] = {0, 1, 0, -1};

    board[x][y] = 1;
    visited[x][y] = true;

    push(x, y);

    while (top > 0) {
        current = pop();
        int nx = current.x + dx[rand() % 4];
        int ny = current.y + dy[rand() % 4];

        if (is_valid_move(nx, ny)) {
            board[nx][ny] = 1;
            visited[nx][ny] = true;
            push(nx, ny);
        }
    }
}

int main() {
    int i, j;
    int seed = time(NULL);
    srand(seed);

    for (i = 0; i < GRID_SIZE; i++) {
        for (j = 0; j < GRID_SIZE; j++) {
            board[i][j] = rand() % 2;
        }
    }

    for (i = 0; i < GRID_SIZE; i++) {
        for (j = 0; j < GRID_SIZE; j++) {
            if (board[i][j] == 1) {
                flood_fill(i, j);
            }
        }
    }

    print_board();

    return 0;
}