//GEMINI-pro DATASET v1.0 Category: Client Server Application ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
    int server_fd, client_fd;
    struct sockaddr_in server_addr, client_addr;
    socklen_t client_addr_len;
    char buffer[1024];
    char message[] = "Hello from the server!";

    // Create a server socket
    if ((server_fd = socket(AF_INET, SOCK_STREAM, 0)) == -1) {
        perror("socket");
        exit(1);
    }

    // Set the server address and port
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(PORT);
    server_addr.sin_addr.s_addr = INADDR_ANY;

    // Bind the socket to the server address
    if (bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("bind");
        exit(1);
    }

    // Listen for incoming connections
    if (listen(server_fd, 5) == -1) {
        perror("listen");
        exit(1);
    }

    // Accept a client connection
    client_addr_len = sizeof(client_addr);
    if ((client_fd = accept(server_fd, (struct sockaddr *)&client_addr, &client_addr_len)) == -1) {
        perror("accept");
        exit(1);
    }

    // Send a message to the client
    if (send(client_fd, message, strlen(message), 0) == -1) {
        perror("send");
        exit(1);
    }

    // Receive a message from the client
    if (recv(client_fd, buffer, sizeof(buffer), 0) == -1) {
        perror("recv");
        exit(1);
    }

    // Print the received message
    printf("Received message from client: %s\n", buffer);

    // Close the client connection
    close(client_fd);

    // Close the server socket
    close(server_fd);

    return 0;
}