//Falcon-180B DATASET v1.0 Category: Terminal Based Game ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 80
#define HEIGHT 24
#define MAP_WIDTH 10
#define MAP_HEIGHT 10

#define TILE_WALL '#'
#define TILE_FLOOR '.'
#define TILE_DOOR 'D'
#define TILE_PLAYER '@'
#define TILE_ENEMY 'E'
#define TILE_ITEM '$'

typedef struct {
    int x, y;
} Point;

void init_map(char map[MAP_HEIGHT][MAP_WIDTH]) {
    for (int i = 0; i < MAP_HEIGHT; i++) {
        for (int j = 0; j < MAP_WIDTH; j++) {
            map[i][j] = TILE_WALL;
        }
    }
}

void print_map(char map[MAP_HEIGHT][MAP_WIDTH]) {
    for (int i = 0; i < MAP_HEIGHT; i++) {
        for (int j = 0; j < MAP_WIDTH; j++) {
            printf("%c", map[i][j]);
        }
        printf("\n");
    }
}

int main() {
    srand(time(NULL));

    char map[MAP_HEIGHT][MAP_WIDTH];
    init_map(map);

    // Place the player at the top left corner
    Point player = {0, 0};

    // Place the door at the bottom right corner
    Point door = {MAP_WIDTH - 1, MAP_HEIGHT - 1};

    // Place an enemy somewhere in the middle
    Point enemy = {rand() % MAP_WIDTH, rand() % MAP_HEIGHT};

    // Place an item somewhere in the middle
    Point item = {rand() % MAP_WIDTH, rand() % MAP_HEIGHT};

    map[player.y][player.x] = TILE_PLAYER;
    map[door.y][door.x] = TILE_DOOR;
    map[enemy.y][enemy.x] = TILE_ENEMY;
    map[item.y][item.x] = TILE_ITEM;

    print_map(map);

    return 0;
}