//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LENGTH 50
#define MAX_PRICE 1000000

typedef struct {
    char name[MAX_NAME_LENGTH];
    int quantity;
    double price;
} Product;

void addProduct(Product *products, int numProducts, char *name, int quantity, double price) {
    int i;
    for (i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            products[i].quantity += quantity;
            return;
        }
    }
    strcpy(products[numProducts].name, name);
    products[numProducts].quantity = quantity;
    products[numProducts].price = price;
    numProducts++;
}

void removeProduct(Product *products, int numProducts, char *name) {
    int i;
    for (i = 0; i < numProducts; i++) {
        if (strcmp(products[i].name, name) == 0) {
            products[i] = products[--numProducts];
            return;
        }
    }
}

void displayProducts(Product *products, int numProducts) {
    int i;
    for (i = 0; i < numProducts; i++) {
        printf("%s: %d items at $%.2f\n", products[i].name, products[i].quantity, products[i].price);
    }
}

int main() {
    Product products[MAX_PRODUCTS];
    int numProducts = 0;

    addProduct(products, numProducts, "Widget A", 100, 10.00);
    addProduct(products, numProducts, "Widget B", 50, 20.00);
    addProduct(products, numProducts, "Widget C", 200, 5.00);

    displayProducts(products, numProducts);

    removeProduct(products, numProducts, "Widget A");
    removeProduct(products, numProducts, "Widget C");

    displayProducts(products, numProducts);

    return 0;
}