//Gemma-7B DATASET v1.0 Category: Network Ping Test ; Style: modular
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>

int main()
{
  char *hostname = "localhost";
  int sockfd, result;
  struct sockaddr_in servaddr;

  // Create a socket
  sockfd = socket(AF_INET, SOCK_DGRAM, htons(22));
  if (sockfd < 0)
  {
    perror("Error creating socket");
    exit(1);
  }

  // Set up the server address
  servaddr.sin_family = AF_INET;
  servaddr.sin_port = htons(5000);
  servaddr.sin_addr.s_addr = inet_addr(hostname);

  // Send a ping message
  char message[] = "Ping!";
  result = sendto(sockfd, message, sizeof(message), 0, (struct sockaddr *)&servaddr, sizeof(servaddr));
  if (result < 0)
  {
    perror("Error sending message");
    exit(1);
  }

  // Receive the reply message
  char reply[1024];
  result = recvfrom(sockfd, reply, sizeof(reply), 0, (struct sockaddr *)&servaddr, NULL);
  if (result < 0)
  {
    perror("Error receiving message");
    exit(1);
  }

  // Print the reply message
  printf("Reply: %s\n", reply);

  // Close the socket
  close(sockfd);

  return 0;
}