//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define WIDTH 20
#define HEIGHT 10

void initializeCanvas(char canvas[HEIGHT][WIDTH]);
void drawFace(char canvas[HEIGHT][WIDTH]);
void printCanvas(char canvas[HEIGHT][WIDTH]);

int main() {
    // Exciting start!
    printf("Welcome to the Pixel Art Generator! Let's create some amazing art! 🎨\n\n");

    // Create a canvas for our pixel art
    char canvas[HEIGHT][WIDTH];
    initializeCanvas(canvas);
    drawFace(canvas);
    printCanvas(canvas);

    printf("\nArt generation complete! Enjoy your masterpiece! ✨\n");
    return 0;
}

void initializeCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            canvas[i][j] = ' ';  // Initialize with blank spaces
        }
    }
}

void drawFace(char canvas[HEIGHT][WIDTH]) {
    // Drawing a face with eyes, a smile, and a happy vibe
    canvas[2][5] = 'O';   // Left eye
    canvas[2][14] = 'O';  // Right eye
    canvas[5][7] = '\\';  // Left side of the smile
    canvas[5][8] = '_';   // Middle of the smile
    canvas[5][9] = '_';   // Middle of the smile
    canvas[5][10] = '/';  // Right side of the smile
    for (int i = 1; i < WIDTH - 1; i++) {
        canvas[1][i] = '-'; // Top part of the head
        canvas[8][i] = '-'; // Bottom part of the head
    }
    // Outline of the face
    for (int i = 0; i < HEIGHT; i++) {
        canvas[i][0] = '|';           // Left border
        canvas[i][WIDTH - 1] = '|';   // Right border
    }
    for (int j = 0; j < WIDTH; j++) {
        canvas[0][j] = '_';            // Top border
        canvas[HEIGHT - 1][j] = '-';   // Bottom border
    }
}

void printCanvas(char canvas[HEIGHT][WIDTH]) {
    printf("Here is your pixel art:\n");
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            putchar(canvas[i][j]);
        }
        putchar('\n'); // Move to the next line
    }
}