//Falcon-180B DATASET v1.0 Category: Digital Auction System ; Style: introspective
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_BIDDERS 100
#define MAX_BIDS 100

typedef struct {
    char name[50];
    int id;
} Bidder;

typedef struct {
    char name[50];
    int id;
    int highest_bid;
} Item;

typedef struct {
    int bidder_id;
    int item_id;
    int amount;
} Bid;

Bidder bidders[MAX_BIDDERS];
Item items[MAX_ITEMS];
Bid bids[MAX_BIDS];

int num_bidders = 0;
int num_items = 0;
int num_bids = 0;

void add_bidder(char* name) {
    strcpy(bidders[num_bidders].name, name);
    bidders[num_bidders].id = num_bidders;
    num_bidders++;
}

void add_item(char* name) {
    strcpy(items[num_items].name, name);
    items[num_items].id = num_items;
    num_items++;
}

void add_bid(int bidder_id, int item_id, int amount) {
    bids[num_bids].bidder_id = bidder_id;
    bids[num_bids].item_id = item_id;
    bids[num_bids].amount = amount;
    num_bids++;
}

void print_bidders() {
    printf("Bidders:\n");
    for (int i = 0; i < num_bidders; i++) {
        printf("%d. %s\n", i, bidders[i].name);
    }
}

void print_items() {
    printf("Items:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%d. %s\n", i, items[i].name);
    }
}

void print_bids() {
    printf("Bids:\n");
    for (int i = 0; i < num_bids; i++) {
        printf("%d. Bidder %d placed a bid of $%d on item %d.\n", i, bids[i].bidder_id, bids[i].amount, bids[i].item_id);
    }
}

int main() {
    add_bidder("Alice");
    add_bidder("Bob");
    add_item("Laptop");
    add_item("Phone");
    add_bid(0, 0, 500);
    add_bid(1, 0, 600);
    add_bid(0, 1, 700);
    print_bidders();
    print_items();
    print_bids();
    return 0;
}