//GEMINI-pro DATASET v1.0 Category: Sentiment analysis tool ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_WORDS 100
#define MAX_SENTENCES 100

struct word {
  char *word;
  int count;
};

struct sentence {
  char *sentence;
  int count;
};

struct sentiment {
  int positive;
  int negative;
  int neutral;
};

struct word_list {
  struct word words[MAX_WORDS];
  int size;
};

struct sentence_list {
  struct sentence sentences[MAX_SENTENCES];
  int size;
};

struct sentiment_list {
  struct sentiment sentiments[MAX_SENTENCES];
  int size;
};

void add_word(struct word_list *list, char *word) {
  int i;
  for (i = 0; i < list->size; i++) {
    if (strcmp(list->words[i].word, word) == 0) {
      list->words[i].count++;
      return;
    }
  }
  if (list->size < MAX_WORDS) {
    list->words[list->size].word = word;
    list->words[list->size].count = 1;
    list->size++;
  }
}

void add_sentence(struct sentence_list *list, char *sentence) {
  int i;
  for (i = 0; i < list->size; i++) {
    if (strcmp(list->sentences[i].sentence, sentence) == 0) {
      list->sentences[i].count++;
      return;
    }
  }
  if (list->size < MAX_SENTENCES) {
    list->sentences[list->size].sentence = sentence;
    list->sentences[list->size].count = 1;
    list->size++;
  }
}

void add_sentiment(struct sentiment_list *list, int positive, int negative, int neutral) {
  if (list->size < MAX_SENTENCES) {
    list->sentiments[list->size].positive = positive;
    list->sentiments[list->size].negative = negative;
    list->sentiments[list->size].neutral = neutral;
    list->size++;
  }
}

void print_word_list(struct word_list *list) {
  int i;
  for (i = 0; i < list->size; i++) {
    printf("%s: %d\n", list->words[i].word, list->words[i].count);
  }
}

void print_sentence_list(struct sentence_list *list) {
  int i;
  for (i = 0; i < list->size; i++) {
    printf("%s: %d\n", list->sentences[i].sentence, list->sentences[i].count);
  }
}

void print_sentiment_list(struct sentiment_list *list) {
  int i;
  for (i = 0; i < list->size; i++) {
    printf("Positive: %d, Negative: %d, Neutral: %d\n", list->sentiments[i].positive,
             list->sentiments[i].negative, list->sentiments[i].neutral);
  }
}

int main(int argc, char *argv[]) {
  if (argc < 2) {
    printf("Usage: %s <text file>\n", argv[0]);
    return 1;
  }

  FILE *file = fopen(argv[1], "r");
  if (file == NULL) {
    printf("Error opening file %s\n", argv[1]);
    return 1;
  }

  char *text = NULL;
  size_t len = 0;
  getline(&text, &len, file);
  fclose(file);

  struct word_list word_list;
  word_list.size = 0;

  struct sentence_list sentence_list;
  sentence_list.size = 0;

  struct sentiment_list sentiment_list;
  sentiment_list.size = 0;

  char *word = strtok(text, " ");
  while (word != NULL) {
    add_word(&word_list, word);
    word = strtok(NULL, " ");
  }

  char *sentence = strtok(text, ".");
  while (sentence != NULL) {
    add_sentence(&sentence_list, sentence);
    sentence = strtok(NULL, ".");
  }

  int positive = 0;
  int negative = 0;
  int neutral = 0;

  for (int i = 0; i < word_list.size; i++) {
    if (strcmp(word_list.words[i].word, "good") == 0 ||
        strcmp(word_list.words[i].word, "great") == 0 ||
        strcmp(word_list.words[i].word, "excellent") == 0) {
      positive++;
    } else if (strcmp(word_list.words[i].word, "bad") == 0 ||
               strcmp(word_list.words[i].word, "terrible") == 0 ||
               strcmp(word_list.words[i].word, "awful") == 0) {
      negative++;
    } else {
      neutral++;
    }
  }

  add_sentiment(&sentiment_list, positive, negative, neutral);

  print_word_list(&word_list);
  print_sentence_list(&sentence_list);
  print_sentiment_list(&sentiment_list);

  free(text);

  return 0;
}