//GPT-4o-mini DATASET v1.0 Category: Arithmetic ; Style: Romeo and Juliet
#include <stdio.h>

typedef struct {
    char name[30];
    int heartCount; // Represents the number of hearts won
    float affection; // Represents the level of affection
} Character;

// Function prototypes
void increaseAffection(Character* lover, int hearts);
void displayAffection(Character lover);

int main() {
    Character romeo = {"Romeo", 0, 0.0};
    Character juliet = {"Juliet", 0, 0.0};

    printf("In fair Verona, where we lay our scene...\n");
    printf("Two star-crossed lovers, united by fate.\n\n");

    // Initial display of affection
    displayAffection(romeo);
    displayAffection(juliet);

    // The wooing begins!
    printf("And so begins their tale of hearts and dreams...\n");
    
    // Romeo wins hearts through kind actions
    increaseAffection(&romeo, 5);
    increaseAffection(&juliet, 3);
    
    printf("\nAfter sweet gestures and promises of love:\n");

    // Display affection after actions
    displayAffection(romeo);
    displayAffection(juliet);

    // The tragic twist - misunderstandings arise
    printf("\nBut hark! Misunderstandings brew...\n");
    increaseAffection(&romeo, -2); // Romeo loses affection
    increaseAffection(&juliet, 2); // Juliet increases her affection

    // Final display of affection
    printf("\nIn the heat of passion and misunderstanding:\n");
    displayAffection(romeo);
    displayAffection(juliet);

    // The moment of truth - Calculate their fates
    if (romeo.affection > juliet.affection) {
        printf("\nAlas, it seems Romeo's heart beats stronger...\n");
    } else if (romeo.affection < juliet.affection) {
        printf("\nOh woe! Juliet's heart burns brighter...\n");
    } else {
        printf("\nIn equal measure, their love prevails!\n");
    }

    printf("\nThe tale ends, but love's arithmetic never does...\n");
    return 0;
}

void increaseAffection(Character* lover, int hearts) {
    if (hearts > 0) {
        lover->heartCount += hearts;
        lover->affection += hearts * 1.5; // Each heart adds 1.5 to affection
        printf("%s wins %d hearts! Affection increases!\n", lover->name, hearts);
    } else {
        lover->heartCount += hearts; // Deduct hearts
        lover->affection += hearts * 1.0; // Each lost heart subtracts 1.0 from affection
        printf("%s loses %d hearts! Affection decreases!\n", lover->name, -hearts);
    }
}

void displayAffection(Character lover) {
    printf("%s's hearts: %d\n", lover.name, lover.heartCount);
    printf("%s's affection level: %.2f\n\n", lover.name, lover.affection);
}