//Falcon-180B DATASET v1.0 Category: Color Code Converter ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_COLOR_CODE_LENGTH 7

struct color_code {
    char name[MAX_COLOR_CODE_LENGTH];
    int value;
};

struct color_code color_codes[] = {
    {"black", 0},
    {"white", 7},
    {"red", 31},
    {"green", 32},
    {"yellow", 33},
    {"blue", 34},
    {"magenta", 35},
    {"cyan", 36},
    {"gray", 37},
    {"dark_gray", 90},
    {"light_red", 91},
    {"light_green", 92},
    {"light_yellow", 93},
    {"light_blue", 94},
    {"light_magenta", 95},
    {"light_cyan", 96},
    {"light_gray", 97}
};

int main() {
    int num_color_codes = sizeof(color_codes) / sizeof(struct color_code);

    printf("Enter a color code (or type 'list' to see all color codes): ");
    char input[MAX_COLOR_CODE_LENGTH];
    fgets(input, MAX_COLOR_CODE_LENGTH, stdin);

    if (strcmp(input, "list") == 0) {
        printf("Available color codes:\n");
        for (int i = 0; i < num_color_codes; i++) {
            printf("%s (%d)\n", color_codes[i].name, color_codes[i].value);
        }
    } else {
        int color_code_value = -1;

        for (int i = 0; i < num_color_codes; i++) {
            if (strcmp(color_codes[i].name, input) == 0) {
                color_code_value = color_codes[i].value;
                break;
            }
        }

        if (color_code_value == -1) {
            printf("Invalid color code.\n");
        } else {
            printf("Color code value: %d\n", color_code_value);
        }
    }

    return 0;
}