//Falcon-180B DATASET v1.0 Category: Stock market tracker ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SYMBOLS 100
#define MAX_HISTORY 1000

typedef struct {
    char symbol[10];
    double current_price;
    double history_prices[MAX_HISTORY];
    int history_index;
} Symbol;

Symbol symbols[MAX_SYMBOLS];
int num_symbols = 0;

void add_symbol(char *symbol) {
    if (num_symbols >= MAX_SYMBOLS) {
        printf("Error: Maximum number of symbols reached.\n");
        return;
    }
    strcpy(symbols[num_symbols].symbol, symbol);
    symbols[num_symbols].current_price = 0.0;
    symbols[num_symbols].history_index = 0;
    num_symbols++;
}

void update_symbol_price(char *symbol, double price) {
    int i;
    for (i = 0; i < num_symbols; i++) {
        if (strcmp(symbols[i].symbol, symbol) == 0) {
            symbols[i].current_price = price;
            symbols[i].history_prices[symbols[i].history_index] = price;
            symbols[i].history_index++;
            if (symbols[i].history_index >= MAX_HISTORY) {
                symbols[i].history_index = 0;
            }
            return;
        }
    }
    printf("Error: Symbol not found.\n");
}

void print_symbol_history(char *symbol) {
    int i;
    for (i = 0; i < num_symbols; i++) {
        if (strcmp(symbols[i].symbol, symbol) == 0) {
            printf("Symbol: %s\n", symbols[i].symbol);
            printf("Current price: $%.2f\n", symbols[i].current_price);
            printf("Price history:\n");
            int j;
            for (j = 0; j < symbols[i].history_index; j++) {
                printf("$%.2f on %s\n", symbols[i].history_prices[j], ctime(&symbols[i].history_prices[j]));
            }
            return;
        }
    }
    printf("Error: Symbol not found.\n");
}

int main() {
    add_symbol("AAPL");
    add_symbol("MSFT");
    update_symbol_price("AAPL", 123.45);
    update_symbol_price("MSFT", 67.89);
    print_symbol_history("AAPL");
    print_symbol_history("MSFT");
    return 0;
}