//GEMINI-pro DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: inquisitive
#include <stdio.h>
#include <stdbool.h>
#include <stdlib.h>

// Process structure
typedef struct Process {
    int pid;        // Process ID
    int arrival;    // Arrival time
    int burst;      // Burst time
    int priority;   // Priority
    int waiting;    // Waiting time
    int turnaround; // Turnaround time
} Process;

// Function to compare processes by arrival time
int compareArrival(const void *a, const void *b) {
    const Process *p1 = (const Process *) a;
    const Process *p2 = (const Process *) b;
    return p1->arrival - p2->arrival;
}

// Function to compare processes by priority
int comparePriority(const void *a, const void *b) {
    const Process *p1 = (const Process *) a;
    const Process *p2 = (const Process *) b;
    return p1->priority - p2->priority;
}

// Function to calculate waiting time
void calculateWaitingTime(Process processes[], int n, int quantum) {
    int current_time = 0;
    int remaining_time[n];
    for (int i = 0; i < n; i++) {
        remaining_time[i] = processes[i].burst;
    }

    while (true) {
        bool all_completed = true;
        for (int i = 0; i < n; i++) {
            if (remaining_time[i] > 0) {
                all_completed = false;
                if (remaining_time[i] <= quantum) {
                    current_time += remaining_time[i];
                    processes[i].waiting = current_time - processes[i].arrival - processes[i].burst;
                    remaining_time[i] = 0;
                } else {
                    current_time += quantum;
                    remaining_time[i] -= quantum;
                }
            }
        }
        if (all_completed) {
            break;
        }
    }
}

// Function to calculate turnaround time
void calculateTurnaroundTime(Process processes[], int n) {
    for (int i = 0; i < n; i++) {
        processes[i].turnaround = processes[i].waiting + processes[i].burst;
    }
}

// Function to print the scheduling results
void printSchedulingResults(Process processes[], int n) {
    printf("\nScheduling Results:\n");
    printf("%-5s %-8s %-8s %-8s %-8s %-8s\n", "PID", "Arrival", "Burst", "Priority", "Waiting", "Turnaround");
    for (int i = 0; i < n; i++) {
        printf("%-5d %-8d %-8d %-8d %-8d %-8d\n", processes[i].pid, processes[i].arrival, processes[i].burst, processes[i].priority, processes[i].waiting, processes[i].turnaround);
    }
}

// Main function
int main() {
    // Create a set of processes
    Process processes[] = {
        {1, 0, 5, 3},
        {2, 2, 3, 1},
        {3, 4, 4, 2},
        {4, 6, 2, 4},
        {5, 8, 1, 5}
    };
    int n = sizeof(processes) / sizeof(processes[0]);

    // Sort the processes by arrival time
    qsort(processes, n, sizeof(Process), compareArrival);

    // Calculate waiting time
    calculateWaitingTime(processes, n, 2);

    // Calculate turnaround time
    calculateTurnaroundTime(processes, n);

    // Print the scheduling results
    printSchedulingResults(processes, n);

    return 0;
}