//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: systematic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Define the maximum number of drones that can be controlled
#define MAX_DRONES 10

// Define the structure for a drone
typedef struct {
    char name[20];
    int x, y, z;
    int speed;
} Drone;

// Define the function prototypes
void initDrone(Drone *d);
void moveDrone(Drone *d, int dx, int dy, int dz);

int main() {
    // Initialize the drones
    Drone drones[MAX_DRONES];
    int numDrones = 0;

    // Initialize the first drone
    initDrone(&drones[numDrones]);
    numDrones++;

    // Add more drones if desired
    initDrone(&drones[numDrones]);
    numDrones++;

    // Loop through the drones and move them
    for (int i = 0; i < numDrones; i++) {
        moveDrone(&drones[i], 0, 0, 1);
    }

    return 0;
}

// Initialize a drone with default values
void initDrone(Drone *d) {
    strcpy(d->name, "Drone");
    d->x = 0;
    d->y = 0;
    d->z = 0;
    d->speed = 1;
}

// Move a drone in the x, y, and z directions
void moveDrone(Drone *d, int dx, int dy, int dz) {
    printf("Moving drone %s %d units in the x direction...\n", d->name, dx);
    d->x += dx;

    printf("Moving drone %s %d units in the y direction...\n", d->name, dy);
    d->y += dy;

    printf("Moving drone %s %d units in the z direction...\n", d->name, dz);
    d->z += dz;
}