//Gemma-7B DATASET v1.0 Category: Product Inventory System ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct Item
{
    char name[20];
    int quantity;
    double price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name, int quantity, double price)
{
    for (int i = 0; i < MAX_ITEMS; i++)
    {
        if (items[i].name[0] == '\0')
        {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Inventory full.\n");
}

void updateQuantity(char name, int quantity)
{
    for (int i = 0; i < MAX_ITEMS; i++)
    {
        if (strcmp(items[i].name, name) == 0)
        {
            items[i].quantity = quantity;
            return;
        }
    }

    printf("Error: Item not found.\n");
}

double getTotalPrice()
{
    double total_price = 0.0;
    for (int i = 0; i < MAX_ITEMS; i++)
    {
        total_price += items[i].quantity * items[i].price;
    }

    return total_price;
}

void printInventory()
{
    printf("Inventory:\n");
    for (int i = 0; i < MAX_ITEMS; i++)
    {
        if (items[i].name[0] != '\0')
        {
            printf("%s: %d, $%.2lf\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

int main()
{
    addItem("Apple", 10, 1.20);
    addItem("Banana", 5, 0.80);
    addItem("Orange", 7, 0.90);
    updateQuantity("Apple", 15);
    printInventory();
    printf("Total price: $%.2lf\n", getTotalPrice());

    return 0;
}