//MISTRAL-7B DATASET v1.0 Category: Mailing list manager ; Style: medieval
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_NAME_LENGTH 50
#define MAX_EMAIL_LENGTH 100
#define MAX_LIST_SIZE 100

typedef struct knight {
    char name[MAX_NAME_LENGTH];
    char email[MAX_EMAIL_LENGTH];
} knight;

typedef struct list {
    knight members[MAX_LIST_SIZE];
    int count;
} list;

void add_knight_to_list(list *list, const char *name, const char *email) {
    if (list->count >= MAX_LIST_SIZE) {
        printf("The list is full.\n");
        return;
    }
    strcpy(list->members[list->count].name, name);
    strcpy(list->members[list->count].email, email);
    list->count++;
}

void remove_knight_from_list(list *list, int index) {
    if (index < 0 || index >= list->count) {
        printf("Invalid index.\n");
        return;
    }
    int i;
    for (i = index; i < list->count - 1; i++) {
        strcpy(list->members[i].name, list->members[i + 1].name);
        strcpy(list->members[i].email, list->members[i + 1].email);
    }
    list->count--;
}

void print_list(const list *list) {
    int i;
    for (i = 0; i < list->count; i++) {
        printf("%s, %s\n", list->members[i].name, list->members[i].email);
    }
}

int main() {
    list my_list = {0};

    add_knight_to_list(&my_list, "Sir Lancelot", "lancelot@camelot.com");
    add_knight_to_list(&my_list, "Sir Galahad", "galahad@camelot.com");
    add_knight_to_list(&my_list, "Sir Gawain", "gawain@camelot.com");

    print_list(&my_list);

    remove_knight_from_list(&my_list, 1);

    print_list(&my_list);

    return 0;
}