//MISTRAL-7B DATASET v1.0 Category: Medical Store Management System ; Style: funny
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct Medicine {
    char name[50];
    int stock;
    float price;
} Medicine;

typedef struct Store {
    Medicine meds[10];
    int num_meds;
} Store;

void addMedicine(Store *store, const char *name, int stock, float price) {
    if (store->num_meds == 10) {
        printf("Oops! Store is full. Can't add %s.\n", name);
        return;
    }
    strcpy(store->meds[store->num_meds].name, name);
    store->meds[store->num_meds].stock = stock;
    store->meds[store->num_meds].price = price;
    store->num_meds++;
}

void sellMedicine(Store *store, const char *name, int quantity) {
    int i;
    for (i = 0; i < store->num_meds; i++) {
        if (strcmp(store->meds[i].name, name) == 0) {
            if (store->meds[i].stock < quantity) {
                printf("Darn! We don't have enough %s in stock.\n", name);
                return;
            }
            store->meds[i].stock -= quantity;
            printf("%d units of %s sold. Current stock: %d\n", quantity, name, store->meds[i].stock);
            return;
        }
    }
    printf("Uh oh! We don't sell %s here.\n", name);
}

int main() {
    Store my_store = {0};

    addMedicine(&my_store, "Aspirin", 50, 1.5);
    addMedicine(&my_store, "Bandage", 100, 2.0);
    addMedicine(&my_store, "Paracetamol", 75, 2.5);

    sellMedicine(&my_store, "Aspirin", 10);
    sellMedicine(&my_store, "Bandage", 50);
    sellMedicine(&my_store, "Viagra", 3); // Just for fun!

    return 0;
}