//Gemma-7B DATASET v1.0 Category: Product Inventory System ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void add_item(char name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Inventory is full.\n");
}

void remove_item(char name) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = 0;
            return;
        }
    }

    printf("Error: Item not found.\n");
}

void update_quantity(char name, int quantity) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = quantity;
            return;
        }
    }

    printf("Error: Item not found.\n");
}

int main() {
    add_item("Apple", 10, 1.2);
    add_item("Banana", 5, 0.8);
    add_item("Orange", 7, 1.5);
    remove_item("Banana");
    update_quantity("Apple", 12);

    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s: %d, $%.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }

    return 0;
}