//GEMINI-pro DATASET v1.0 Category: Building a SMTP Client ; Style: lively
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

int main() {
  // Set up the SMTP server address and port
  struct sockaddr_in server_addr;
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_port = htons(25);
  server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");

  // Create a TCP socket
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    perror("socket");
    exit(1);
  }

  // Establish a connection to the SMTP server
  if (connect(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
    perror("connect");
    exit(1);
  }

  // Read the greeting from the SMTP server
  char greeting[1024];
  memset(greeting, 0, sizeof(greeting));
  if (recv(sockfd, greeting, sizeof(greeting) - 1, 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("%s", greeting);

  // Send the HELO command to the SMTP server
  const char *helo_command = "HELO localhost\r\n";
  if (send(sockfd, helo_command, strlen(helo_command), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Read the response from the SMTP server
  char response[1024];
  memset(response, 0, sizeof(response));
  if (recv(sockfd, response, sizeof(response) - 1, 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("%s", response);

  // Send the MAIL FROM command to the SMTP server
  const char *mail_from_command = "MAIL FROM: <you@example.com>\r\n";
  if (send(sockfd, mail_from_command, strlen(mail_from_command), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Read the response from the SMTP server
  memset(response, 0, sizeof(response));
  if (recv(sockfd, response, sizeof(response) - 1, 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("%s", response);

  // Send the RCPT TO command to the SMTP server
  const char *rcpt_to_command = "RCPT TO: <recipient@example.com>\r\n";
  if (send(sockfd, rcpt_to_command, strlen(rcpt_to_command), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Read the response from the SMTP server
  memset(response, 0, sizeof(response));
  if (recv(sockfd, response, sizeof(response) - 1, 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("%s", response);

  // Send the DATA command to the SMTP server
  const char *data_command = "DATA\r\n";
  if (send(sockfd, data_command, strlen(data_command), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Read the response from the SMTP server
  memset(response, 0, sizeof(response));
  if (recv(sockfd, response, sizeof(response) - 1, 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("%s", response);

  // Send the email body to the SMTP server
  const char *email_body = "Hello, world!\n\nThis is an email sent using a C SMTP client.\n\nBest regards,\n\nYou";
  if (send(sockfd, email_body, strlen(email_body), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Send a period (.) to the SMTP server to indicate the end of the email body
  const char *period = ".\r\n";
  if (send(sockfd, period, strlen(period), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Read the response from the SMTP server
  memset(response, 0, sizeof(response));
  if (recv(sockfd, response, sizeof(response) - 1, 0) == -1) {
    perror("recv");
    exit(1);
  }
  printf("%s", response);

  // Send the QUIT command to the SMTP server
  const char *quit_command = "QUIT\r\n";
  if (send(sockfd, quit_command, strlen(quit_command), 0) == -1) {
    perror("send");
    exit(1);
  }

  // Close the socket
  close(sockfd);

  return 0;
}