//LLAMA2-13B DATASET v1.0 Category: Socket programming ; Style: creative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

struct message {
    char *data;
    int len;
};

int main() {
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    struct sockaddr_in server_addr = {
        .sin_family = AF_INET,
        .sin_port = htons(PORT),
        .sin_addr.s_addr = inet_addr("127.0.0.1")
    };

    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("connect failed");
        exit(EXIT_FAILURE);
    }

    char message[] = "Hello, world!";
    struct message client_msg = {
        .data = message,
        .len = strlen(message)
    };

    if (send(sock, client_msg.data, client_msg.len, 0) < 0) {
        perror("send failed");
        exit(EXIT_FAILURE);
    }

    char buffer[1024];
    int bytes_recv = recv(sock, buffer, 1024, 0);
    if (bytes_recv < 0) {
        perror("recv failed");
        exit(EXIT_FAILURE);
    }

    printf("%s\n", buffer);

    close(sock);
    return 0;
}