//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: realistic
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    float price;
    int quantity;
} Item;

Item items[MAX_ITEMS];

void addItem(Item item) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            items[i] = item;
            return;
        }
    }
    printf("Error: Item list is full.\n");
}

void removeItem(char name) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].name[0] = '\0';
            return;
        }
    }
    printf("Error: Item not found.\n");
}

void updateQuantity(char name, int quantity) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            items[i].quantity = quantity;
            return;
        }
    }
    printf("Error: Item not found.\n");
}

void calculateTotal(float total) {
    printf("Total: %.2f\n", total);
}

int main() {
    Item item1 = {"Coffee", 5.0, 10};
    addItem(item1);

    Item item2 = {"Tea", 3.0, 5};
    addItem(item2);

    Item item3 = {"Juice", 4.0, 2};
    addItem(item3);

    updateQuantity("Coffee", 15);

    removeItem("Tea");

    float total = 0.0;
    total = total + items[0].price * items[0].quantity;
    total = total + items[2].price * items[2].quantity;

    calculateTotal(total);

    return 0;
}