//Gemma-7B DATASET v1.0 Category: Planet Gravity Simulation ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define G 6.674e-11

typedef struct Planet {
  char name[20];
  double mass;
  double x;
  double y;
  double z;
  double vx;
  double vy;
  double vz;
} Planet;

int main() {
  // Create an array of planets
  Planet planets[] = {
    {"Sun", 1e30, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0},
    {"Earth", 5.97e24, 1.51e11, 0.0, 0.0, 0.0, 0.0, 0.0},
    {"Mars", 0.64e24, 2.48e11, 0.0, 0.0, 0.0, 0.0, 0.0}
  };

  // Calculate the force of gravity between each pair of planets
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      if (i != j) {
        double dx = planets[j].x - planets[i].x;
        double dy = planets[j].y - planets[i].y;
        double dz = planets[j].z - planets[i].z;
        double distance = sqrt(dx * dx + dy * dy + dz * dz);
        double force = G * planets[i].mass * planets[j].mass / distance * distance;

        // Apply the force of gravity to each planet
        planets[i].vx += force * dx / planets[i].mass;
        planets[i].vy += force * dy / planets[i].mass;
        planets[i].vz += force * dz / planets[i].mass;
      }
    }
  }

  // Print the orbital paths of the planets
  for (int i = 0; i < 3; i++) {
    printf("%s's orbit:\n", planets[i].name);
    printf("x: %.2f, y: %.2f, z: %.2f\n", planets[i].x, planets[i].y, planets[i].z);
    printf("vx: %.2f, vy: %.2f, vz: %.2f\n", planets[i].vx, planets[i].vy, planets[i].vz);
    printf("\n");
  }

  return 0;
}