//GEMINI-pro DATASET v1.0 Category: Text to ASCII art generator ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 80
#define HEIGHT 25

char canvas[HEIGHT][WIDTH];

void clearCanvas() {
  for (int y = 0; y < HEIGHT; y++) {
    for (int x = 0; x < WIDTH; x++) {
      canvas[y][x] = ' ';
    }
  }
}

void drawText(char *text, int x, int y) {
  int len = strlen(text);
  for (int i = 0; i < len; i++) {
    canvas[y][x + i] = text[i];
  }
}

void drawBorder() {
  for (int y = 0; y < HEIGHT; y++) {
    canvas[y][0] = '|';
    canvas[y][WIDTH - 1] = '|';
  }
  for (int x = 0; x < WIDTH; x++) {
    canvas[0][x] = '-';
    canvas[HEIGHT - 1][x] = '-';
  }
}

void printCanvas() {
  for (int y = 0; y < HEIGHT; y++) {
    for (int x = 0; x < WIDTH; x++) {
      printf("%c", canvas[y][x]);
    }
    printf("\n");
  }
}

int main() {
  clearCanvas();
  drawText("Hello, world!", 10, 10);
  drawBorder();
  printCanvas();

  return 0;
}