//LLAMA2-13B DATASET v1.0 Category: Sorting ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAX_LENGTH 100

// Definition of a grateful person
typedef struct {
    char name[50];
    int age;
    char quote[50];
} grateful_person;

// Function to sort an array of grateful people by age
void sort_grateful_people_by_age(grateful_person arr[], int size) {
    int i, j, min_idx, temp;

    // Sorting algorithm based on the principle of gratitude
    for (i = 0; i < size - 1; i++) {
        min_idx = i;
        for (j = i + 1; j < size; j++) {
            if (arr[j].age < arr[min_idx].age) {
                min_idx = j;
            }
        }
        temp = arr[i].age;
        arr[i].age = arr[min_idx].age;
        arr[min_idx].age = temp;
    }
}

// Function to print a grateful person
void print_grateful_person(grateful_person person) {
    printf("Name: %s\nAge: %d\nQuote: %s\n", person.name, person.age, person.quote);
}

int main() {
    // Define an array of grateful people
    grateful_person arr[5] = {
        {"Alice", 25, "I'm grateful for the sunshine."},
        {"Bob", 30, "I'm grateful for my family."},
        {"Charlie", 20, "I'm grateful for my friends."},
        {"David", 40, "I'm grateful for my health."},
        {"Eve", 50, "I'm grateful for my life."}
    };

    // Sort the array of grateful people by age
    sort_grateful_people_by_age(arr, sizeof(arr) / sizeof(arr[0]));

    // Print the sorted array of grateful people
    for (int i = 0; i < sizeof(arr) / sizeof(arr[0]); i++) {
        print_grateful_person(arr[i]);
    }

    return 0;
}