//Falcon-180B DATASET v1.0 Category: Personal Finance Planner ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the maximum number of transactions
#define MAX_TRANSACTIONS 100

// Define the transaction structure
typedef struct {
    char date[20];
    char description[100];
    double amount;
} Transaction;

// Define the account structure
typedef struct {
    char name[50];
    double balance;
    Transaction transactions[MAX_TRANSACTIONS];
    int numTransactions;
} Account;

// Define the account functions
void createAccount(Account* account) {
    strcpy(account->name, "");
    account->balance = 0.0;
    account->numTransactions = 0;
}

void deposit(Account* account, double amount) {
    account->balance += amount;
    Transaction transaction;
    strcpy(transaction.date, "");
    strcpy(transaction.description, "Deposit");
    transaction.amount = amount;
    account->transactions[account->numTransactions] = transaction;
    account->numTransactions++;
}

void withdraw(Account* account, double amount) {
    if (account->balance >= amount) {
        account->balance -= amount;
        Transaction transaction;
        strcpy(transaction.date, "");
        strcpy(transaction.description, "Withdrawal");
        transaction.amount = -amount;
        account->transactions[account->numTransactions] = transaction;
        account->numTransactions++;
    } else {
        printf("Insufficient funds.\n");
    }
}

void displayTransactions(Account* account) {
    printf("Transactions for account %s:\n", account->name);
    for (int i = 0; i < account->numTransactions; i++) {
        printf("%s %s $%.2f\n", account->transactions[i].date, account->transactions[i].description, account->transactions[i].amount);
    }
}

void displayAccount(Account* account) {
    printf("Account name: %s\n", account->name);
    printf("Account balance: $%.2f\n", account->balance);
    printf("Number of transactions: %d\n", account->numTransactions);
}

// Define the main function
int main() {
    // Create an account
    Account myAccount;
    createAccount(&myAccount);

    // Deposit some money
    deposit(&myAccount, 1000.00);

    // Withdraw some money
    withdraw(&myAccount, 500.00);

    // Display the account details
    displayAccount(&myAccount);

    // Display the transaction history
    displayTransactions(&myAccount);

    return 0;
}