//MISTRAL-7B DATASET v1.0 Category: Interprocess communication ; Style: grateful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#define PIPE_NAME "my_pipe"

int main() {
    int fd[2];
    char buffer[1024];
    char message_to_send[50] = "Thank you for your time and consideration.";

    // Create a named pipe (FIFO)
    if (mkfifo(PIPE_NAME, 0666) == -1) {
        perror("Error creating pipe");
        exit(1);
    }

    // Open the pipe for reading and writing
    if (pipe(fd) == -1) {
        perror("Error opening pipe");
        exit(1);
    }

    // Write a message to the pipe
    if (write(fd[1], message_to_send, strlen(message_to_send) + 1) == -1) {
        perror("Error writing to pipe");
        exit(1);
    }

    // Read a message from the pipe
    memset(buffer, 0, sizeof(buffer));
    int bytes_read = read(fd[0], buffer, sizeof(buffer) - 1);
    if (bytes_read > 0) {
        printf("Received message: %s\n", buffer);
    } else if (bytes_read == 0) {
        printf("No message received.\n");
    } else {
        perror("Error reading from pipe");
    }

    // Close the pipe
    close(fd[0]);
    close(fd[1]);

    // Remove the named pipe
    if (unlink(PIPE_NAME) == -1) {
        perror("Error removing pipe");
    }

    printf("Press ENTER to exit...\n");
    getchar();

    return 0;
}