//GEMINI-pro DATASET v1.0 Category: URL Sanitizer ; Style: irregular
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

struct url_data {
  char *url;
  char *sanitized_url;
};

size_t write_callback(void *contents, size_t size, size_t nmemb, void *userp) {
  struct url_data *data = (struct url_data *)userp;
  size_t realsize = size * nmemb;
  data->sanitized_url = malloc(realsize + 1);
  if (data->sanitized_url == NULL) {
    return 0;
  }
  memcpy(data->sanitized_url, contents, realsize);
  data->sanitized_url[realsize] = '\0';
  return realsize;
}

int main(int argc, char *argv[]) {
  if (argc != 2) {
    printf("Usage: %s <URL>\n", argv[0]);
    return 1;
  }

  CURL *curl;
  CURLcode res;

  curl = curl_easy_init();
  if (curl == NULL) {
    perror("curl_easy_init");
    return 1;
  }

  struct url_data data;
  data.url = argv[1];
  data.sanitized_url = NULL;

  curl_easy_setopt(curl, CURLOPT_URL, data.url);
  curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, write_callback);
  curl_easy_setopt(curl, CURLOPT_WRITEDATA, &data);

  res = curl_easy_perform(curl);
  if (res != CURLE_OK) {
    perror("curl_easy_perform");
    curl_easy_cleanup(curl);
    return 1;
  }

  printf("Sanitized URL: %s\n", data.sanitized_url);

  curl_easy_cleanup(curl);
  free(data.sanitized_url);

  return 0;
}