//GPT-4o-mini DATASET v1.0 Category: URL Sanitizer ; Style: recursive
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_URL_LENGTH 2048

// Function to determine if a character is valid in a URL
int is_valid_char(char c) {
    return isalnum(c) || c == '-' || c == '_' || c == '.' || c == '~' || c == ':' || c == '/' || c == '?' || c == '&' || c == '=' || c == '%' || c == '#';
}

// Recursive function to sanitize the URL
void sanitize_url_recursive(const char *url_input, char *sanitized_url, int depth, int *index) {
    if (url_input[depth] == '\0') {
        sanitized_url[*index] = '\0'; // null-terminate the sanitized string
        return;
    }

    if (is_valid_char(url_input[depth])) {
        sanitized_url[*index] = url_input[depth];
        (*index)++;
    }

    // Recurse for the next character
    sanitize_url_recursive(url_input, sanitized_url, depth + 1, index);
}

// Main URL sanitization function
void sanitize_url(const char *url_input, char *sanitized_url) {
    int index = 0;
    sanitize_url_recursive(url_input, sanitized_url, 0, &index);
}

// Function to test the sanitizer
void test_sanitizer() {
    const char *test_urls[] = {
        "http://example.com/page?query=123&sort=-date",
        "ftp://user:pass@ftp.example.com/path/to/file.txt",
        "http ://invalid URL.com",
        "https://valid-url.com/path/?param=<invalid>",
        NULL
    };

    for (int i = 0; test_urls[i] != NULL; i++) {
        printf("Original URL: %s\n", test_urls[i]);
        char sanitized_url[MAX_URL_LENGTH];
        sanitize_url(test_urls[i], sanitized_url);
        printf("Sanitized URL: %s\n\n", sanitized_url);
    }
}

int main() {
    printf("URL Sanitizer\n");
    printf("=======================\n");
    test_sanitizer();
    return 0;
}