//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(char name, int quantity, float price) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    printf("Error: Item limit reached.\n");
}

void displayItems() {
    printf("Items:\n");
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

int calculateTotal(int itemsCount) {
    float total = 0.0f;
    for (int i = 0; i < itemsCount; i++) {
        total += items[i].quantity * items[i].price;
    }

    return (int)total;
}

void generateBill(int itemsCount) {
    printf("Bill:\n");
    for (int i = 0; i < itemsCount; i++) {
        printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
    }

    printf("Total: $%d\n", calculateTotal(itemsCount));
    printf("Thank you for your visit!\n");
}

int main() {
    addItem("Coffee", 5, 2.50);
    addItem("Tea", 3, 1.80);
    addItem("Juice", 2, 1.20);

    displayItems();

    generateBill(3);

    return 0;
}