//MISTRAL-7B DATASET v1.0 Category: Temperature monitor ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <string.h>
#define PORT 8080

struct socket {
    int fd;
    struct sockaddr_in server;
};

void die(const char *msg) {
    perror(msg);
    exit(1);
}

int create_socket() {
    int sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd < 0)
        die("socket creation failed");
    return sockfd;
}

void bind_socket(int sockfd, const struct sockaddr_in *server) {
    if (bind(sockfd, (struct sockaddr *)server, sizeof(*server)) < 0)
        die("bind failed");
}

void listen_socket(int sockfd) {
    if (listen(sockfd, 3) < 0)
        die("listen failed");
}

int accept_connection(int sockfd) {
    int new_sockfd = accept(sockfd, NULL, NULL);
    if (new_sockfd < 0)
        die("accept failed");
    return new_sockfd;
}

struct socket client_socket;

void setup() {
    client_socket.fd = accept_connection(0);
    client_socket.server.sin_family = AF_INET;
    client_socket.server.sin_port = htons(PORT);
    inet_pton(AF_INET, "127.0.0.1", &client_socket.server.sin_addr);
}

void read_temperature() {
    char buffer[1024];
    int n = read(client_socket.fd, buffer, sizeof(buffer));
    if (n < 0)
        die("read failed");
    printf("Received message: %s\n", buffer);
    char temp_str[10];
    sscanf(buffer, "Temperature: %s%*c", temp_str);
    float temperature = atof(temp_str);
    printf("Temperature received: %.2f°C\n", temperature);
}

void run() {
    setup();
    read_temperature();
    close(client_socket.fd);
}

int main() {
    int server_sockfd = create_socket();
    int opt = 1;
    setsockopt(server_sockfd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt));
    client_socket.server.sin_family = AF_INET;
    client_socket.server.sin_addr.s_addr = htonl(INADDR_ANY);
    client_socket.server.sin_port = htons(PORT);
    bind_socket(server_sockfd, &client_socket.server);
    listen_socket(server_sockfd);
    run();
    close(server_sockfd);
    return 0;
}