//GEMINI-pro DATASET v1.0 Category: Chat server ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main(int argc, char **argv) {
  // Create a socket.
  int sockfd = socket(AF_INET, SOCK_STREAM, 0);
  if (sockfd == -1) {
    perror("socket");
    exit(EXIT_FAILURE);
  }

  // Bind the socket to the port.
  struct sockaddr_in addr;
  memset(&addr, 0, sizeof(addr));
  addr.sin_family = AF_INET;
  addr.sin_addr.s_addr = htonl(INADDR_ANY);
  addr.sin_port = htons(PORT);
  if (bind(sockfd, (struct sockaddr *)&addr, sizeof(addr)) == -1) {
    perror("bind");
    exit(EXIT_FAILURE);
  }

  // Listen for incoming connections.
  if (listen(sockfd, 5) == -1) {
    perror("listen");
    exit(EXIT_FAILURE);
  }

  // Accept an incoming connection.
  int newsockfd = accept(sockfd, (struct sockaddr *)&addr, (socklen_t *)&addr);
  if (newsockfd == -1) {
    perror("accept");
    exit(EXIT_FAILURE);
  }

  // Read the message from the client.
  char buffer[1024];
  int n = read(newsockfd, buffer, sizeof(buffer));
  if (n == -1) {
    perror("read");
    exit(EXIT_FAILURE);
  }

  // Write the message back to the client.
  if (write(newsockfd, buffer, n) == -1) {
    perror("write");
    exit(EXIT_FAILURE);
  }

  // Close the connection.
  close(newsockfd);
  close(sockfd);

  return 0;
}