//GEMINI-pro DATASET v1.0 Category: URL Sanitizer ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

// Custom callback function to sanitize URLs
size_t sanitize_url_callback(char *buffer, size_t size, size_t nmemb, void *userdata)
{
    // Allocate a new buffer to store the sanitized URL
    char *sanitized_url = malloc(size * nmemb + 1);
    if (!sanitized_url) {
        return 0;
    }

    // Copy the original URL into the new buffer
    memcpy(sanitized_url, buffer, size * nmemb);

    // Replace any unsafe characters with their escaped equivalents
    char *ptr = sanitized_url;
    while (*ptr) {
        switch (*ptr) {
            case '<':
                *ptr = '%3C';
                break;
            case '>':
                *ptr = '%3E';
                break;
            case '"':
                *ptr = '%22';
                break;
            case '\'':
                *ptr = '%27';
                break;
            case '%':
                // Escape the percent sign itself
                *ptr = "%%";
                break;
        }
        ptr++;
    }

    // Copy the sanitized URL back into the original buffer
    memcpy(buffer, sanitized_url, size * nmemb);

    // Free the allocated memory
    free(sanitized_url);

    // Return the number of bytes written
    return size * nmemb;
}

int main(int argc, char **argv)
{
    // Initialize the CURL library
    curl_global_init(CURL_GLOBAL_DEFAULT);

    // Create a CURL handle
    CURL *curl = curl_easy_init();
    if (!curl) {
        fprintf(stderr, "Error: curl_easy_init() failed\n");
        return 1;
    }

    // Set the URL to fetch
    curl_easy_setopt(curl, CURLOPT_URL, argv[1]);

    // Set the custom callback function to sanitize the URL
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, curl);
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, sanitize_url_callback);

    // Perform the request
    CURLcode res = curl_easy_perform(curl);
    if (res != CURLE_OK) {
        fprintf(stderr, "Error: curl_easy_perform() failed: %s\n", curl_easy_strerror(res));
        return 1;
    }

    // Clean up the CURL handle
    curl_easy_cleanup(curl);

    // Clean up the CURL library
    curl_global_cleanup();

    return 0;
}