//GEMINI-pro DATASET v1.0 Category: Geometric algorithms ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point p1;
    Point p2;
} LineSegment;

typedef struct {
    LineSegment ls1;
    LineSegment ls2;
} PairOfLineSegments;

double distance(const Point *p1, const Point *p2) {
    return sqrt(pow(p2->x - p1->x, 2) + pow(p2->y - p1->y, 2));
}

double dotProduct(const LineSegment *ls1, const LineSegment *ls2) {
    return (ls1->p2.x - ls1->p1.x) * (ls2->p2.x - ls2->p1.x) +
           (ls1->p2.y - ls1->p1.y) * (ls2->p2.y - ls2->p1.y);
}

double crossProduct(const LineSegment *ls1, const LineSegment *ls2) {
    return (ls1->p2.x - ls1->p1.x) * (ls2->p2.y - ls2->p1.y) -
           (ls1->p2.y - ls1->p1.y) * (ls2->p2.x - ls2->p1.x);
}

int areSegmentsIntersecting(const LineSegment *ls1, const LineSegment *ls2) {
    double d1 = dotProduct(ls1, ls2);
    double d2 = dotProduct(ls2, ls1);
    if (d1 * d2 < 0) {
        return 1;
    } else {
        return 0;
    }
}

int areSegmentsColinear(const LineSegment *ls1, const LineSegment *ls2) {
    if (crossProduct(ls1, ls2) == 0) {
        return 1;
    } else {
        return 0;
    }
}

int main() {
    PairOfLineSegments pols[4] = {
        {{0, 0}, {1, 1}},
        {{0, 0}, {1, 1}},
        {{0, 0}, {1, 2}},
        {{0, 0}, {0, 1}}
    };

    for (int i = 0; i < 4; i++) {
        if (areSegmentsIntersecting(&pols[i].ls1, &pols[i].ls2)) {
            printf("Segments %d and %d intersect.\n", i + 1, i + 2);
        } else {
            printf("Segments %d and %d do not intersect.\n", i + 1, i + 2);
        }

        if (areSegmentsColinear(&pols[i].ls1, &pols[i].ls2)) {
            printf("Segments %d and %d are colinear.\n", i + 1, i + 2);
        } else {
            printf("Segments %d and %d are not colinear.\n", i + 1, i + 2);
        }
    }

    return 0;
}