//Falcon-180B DATASET v1.0 Category: Bitwise operations ; Style: innovative
#include <stdio.h>
#include <stdlib.h>

#define NUM_BITS 8

typedef struct {
    unsigned char bytes[NUM_BITS];
} BitArray;

void initBitArray(BitArray* bitArray) {
    for (int i = 0; i < NUM_BITS; i++) {
        bitArray->bytes[i] = 0;
    }
}

void setBit(BitArray* bitArray, int bitIndex) {
    int byteIndex = bitIndex / NUM_BITS;
    int bitInByte = bitIndex % NUM_BITS;

    bitArray->bytes[byteIndex] |= (1 << bitInByte);
}

int getBit(BitArray* bitArray, int bitIndex) {
    int byteIndex = bitIndex / NUM_BITS;
    int bitInByte = bitIndex % NUM_BITS;

    return (bitArray->bytes[byteIndex] & (1 << bitInByte)) >> bitInByte;
}

void printBitArray(BitArray* bitArray) {
    for (int i = 0; i < NUM_BITS; i++) {
        for (int j = 0; j < NUM_BITS; j++) {
            printf("%d", getBit(bitArray, i * NUM_BITS + j));
        }
        printf("\n");
    }
}

int main() {
    BitArray bitArray1, bitArray2;
    initBitArray(&bitArray1);
    initBitArray(&bitArray2);

    setBit(&bitArray1, 3);
    setBit(&bitArray1, 5);
    setBit(&bitArray1, 7);

    setBit(&bitArray2, 2);
    setBit(&bitArray2, 4);
    setBit(&bitArray2, 6);

    BitArray result;
    result.bytes[0] = bitArray1.bytes[0] | bitArray2.bytes[0];
    result.bytes[1] = bitArray1.bytes[1] | bitArray2.bytes[1];

    printf("BitArray1:\n");
    printBitArray(&bitArray1);

    printf("BitArray2:\n");
    printBitArray(&bitArray2);

    printf("Result:\n");
    printBitArray(&result);

    return 0;
}