//GPT-4o-mini DATASET v1.0 Category: Modern Encryption ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/aes.h>
#include <openssl/rand.h>

void handleErrors() {
    fprintf(stderr, "An error occurred.\n");
    exit(1);
}

// Function to encrypt the plaintext
void encrypt(unsigned char *plaintext, unsigned char *key, unsigned char *ciphertext) {
    AES_KEY encryptKey;
    if (AES_set_encrypt_key(key, 128, &encryptKey) < 0) {
        handleErrors();
    }
    AES_encrypt(plaintext, ciphertext, &encryptKey);
}

// Function to decrypt the ciphertext
void decrypt(unsigned char *ciphertext, unsigned char *key, unsigned char *plaintext) {
    AES_KEY decryptKey;
    if (AES_set_decrypt_key(key, 128, &decryptKey) < 0) {
        handleErrors();
    }
    AES_decrypt(ciphertext, plaintext, &decryptKey);
}

int main() {
    // Buffer for the key and the plaintext
    unsigned char key[16] = "0123456789abcdef"; // AES-128 key
    unsigned char plaintext[16] = "Hello, World!!!"; // 16 byte message
    unsigned char ciphertext[16];
    unsigned char decryptedtext[16];

    // Encrypt the plaintext
    encrypt(plaintext, key, ciphertext);

    // Print the ciphertext
    printf("Ciphertext: ");
    for (int i = 0; i < 16; i++) {
        printf("%02x", ciphertext[i]);
    }
    printf("\n");

    // Decrypt the ciphertext
    decrypt(ciphertext, key, decryptedtext);

    // Print the decrypted text
    printf("Decrypted text: ");
    for (int i = 0; i < 16; i++) {
        printf("%c", decryptedtext[i]);
    }
    printf("\n");

    // Ensure the decrypted plaintext matches the original
    if (strcmp((char *)plaintext, (char *)decryptedtext) == 0) {
        printf("Success: Decryption matches original plaintext.\n");
    } else {
        printf("Failure: Decrypted text does not match original plaintext.\n");
    }

    return 0;
}