//Falcon-180B DATASET v1.0 Category: Product Inventory System ; Style: Linus Torvalds
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_NAME_LEN 50
#define MAX_QUANTITY 1000

typedef struct {
    char name[MAX_NAME_LEN];
    int quantity;
    float price;
} Product;

Product products[MAX_PRODUCTS];
int num_products = 0;

void add_product(Product* product) {
    if (num_products >= MAX_PRODUCTS) {
        printf("Error: Maximum number of products reached\n");
        return;
    }

    strcpy(products[num_products].name, product->name);
    products[num_products].quantity = product->quantity;
    products[num_products].price = product->price;

    num_products++;
}

void remove_product(int index) {
    if (index < 0 || index >= num_products) {
        printf("Error: Invalid product index\n");
        return;
    }

    num_products--;

    for (int i = index; i < num_products; i++) {
        strcpy(products[i].name, products[i+1].name);
        products[i].quantity = products[i+1].quantity;
        products[i].price = products[i+1].price;
    }
}

void update_product(int index, Product* product) {
    if (index < 0 || index >= num_products) {
        printf("Error: Invalid product index\n");
        return;
    }

    strcpy(products[index].name, product->name);
    products[index].quantity = product->quantity;
    products[index].price = product->price;
}

void print_products() {
    printf("Product Inventory:\n");
    printf("--------------------\n");

    for (int i = 0; i < num_products; i++) {
        printf("%s\t%d\t$%.2f\n", products[i].name, products[i].quantity, products[i].price);
    }
}

int main() {
    add_product(&(Product){ "Apples", 100, 0.50 });
    add_product(&(Product){ "Oranges", 50, 0.75 });

    print_products();

    remove_product(0);

    print_products();

    update_product(0, &(Product){ "Bananas", 200, 0.25 });

    print_products();

    return 0;
}