//Gemma-7B DATASET v1.0 Category: Unit converter ; Style: complex
#include <stdio.h>
#include <math.h>

#define PI 3.14159

typedef struct Unit {
    char name[20];
    double value;
    double conversion_factor;
} Unit;

Unit units[] = {
    {"Meter", 1.0, 1.0},
    {"Centimeter", 0.01, 10.0},
    {"Millimeter", 0.001, 1000.0},
    {"Liter", 1.0, 1000.0},
    {"Cubic Centimeter", 0.001, 1000.0}
};

double convert_unit(double value, char *from_unit, char *to_unit) {
    int i = 0;
    double conversion_factor = 1.0;

    for (i = 0; i < 5; i++) {
        if (strcmp(units[i].name, from_unit) == 0) {
            conversion_factor = units[i].conversion_factor;
        }
        if (strcmp(units[i].name, to_unit) == 0) {
            return value * conversion_factor;
        }
    }

    return -1.0;
}

int main() {
    double value = 10.0;
    char from_unit[] = "Meter";
    char to_unit[] = "Centimeter";

    double converted_value = convert_unit(value, from_unit, to_unit);

    if (converted_value != -1.0) {
        printf("Converted value: %.2lf %s", converted_value, to_unit);
    } else {
        printf("Error converting units");
    }

    return 0;
}