//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>

#define WIDTH 16
#define HEIGHT 16

// ANSI colors
#define RESET "\033[0m"
#define BLACK "\033[40m"
#define RED "\033[41m"
#define GREEN "\033[42m"
#define YELLOW "\033[43m"
#define BLUE "\033[44m"
#define MAGENTA "\033[45m"
#define CYAN "\033[46m"
#define WHITE "\033[47m"

void initializeCanvas(char canvas[HEIGHT][WIDTH]);
void drawPixel(char canvas[HEIGHT][WIDTH], int x, int y, const char* color);
void displayCanvas(char canvas[HEIGHT][WIDTH]);

int main() {
    char canvas[HEIGHT][WIDTH];

    initializeCanvas(canvas);

    // Draw a smiley face
    drawPixel(canvas, 4, 4, YELLOW);
    drawPixel(canvas, 4, 5, YELLOW);
    drawPixel(canvas, 4, 6, YELLOW);
    drawPixel(canvas, 4, 7, YELLOW);
    drawPixel(canvas, 4, 8, YELLOW);
    
    drawPixel(canvas, 5, 4, YELLOW);
    drawPixel(canvas, 5, 5, YELLOW);
    drawPixel(canvas, 5, 6, RED); // left eye
    drawPixel(canvas, 5, 7, YELLOW);
    drawPixel(canvas, 5, 8, RED); // right eye
    drawPixel(canvas, 5, 9, YELLOW);
    
    drawPixel(canvas, 6, 4, YELLOW);
    drawPixel(canvas, 6, 5, YELLOW);
    
    drawPixel(canvas, 7, 5, YELLOW); // mouth start
    drawPixel(canvas, 7, 6, YELLOW);
    drawPixel(canvas, 7, 7, YELLOW);
    drawPixel(canvas, 7, 8, YELLOW); // mouth end

    // Add some cheerful decorations
    drawPixel(canvas, 0, 14, CYAN); // Sun rays
    drawPixel(canvas, 1, 14, CYAN);
    drawPixel(canvas, 2, 14, CYAN);
    drawPixel(canvas, 0, 13, CYAN);
    drawPixel(canvas, 1, 13, CYAN);
    drawPixel(canvas, 2, 13, CYAN);
    
    // Draw a small tree
    drawPixel(canvas, 12, 12, GREEN);
    drawPixel(canvas, 11, 11, GREEN);
    drawPixel(canvas, 11, 12, GREEN);
    drawPixel(canvas, 11, 13, GREEN);
    drawPixel(canvas, 12, 13, GREEN);
    
    drawPixel(canvas, 12, 11, GREEN); // Tree leaves

    // Display the cheerful canvas
    displayCanvas(canvas);
    
    printf(RESET); // Reset terminal color
    return 0;
}

void initializeCanvas(char canvas[HEIGHT][WIDTH]) {
    for(int i = 0; i < HEIGHT; i++) {
        for(int j = 0; j < WIDTH; j++) {
            canvas[i][j] = ' ';
        }
    }
}

void drawPixel(char canvas[HEIGHT][WIDTH], int x, int y, const char* color) {
    if (x >= 0 && x < HEIGHT && y >= 0 && y < WIDTH) {
        printf("%s  ", color); // Draw with color in terminal
        canvas[x][y] = 'X'; // Mark on canvas
    }
}

void displayCanvas(char canvas[HEIGHT][WIDTH]) {
    printf(RESET); // Reset color before displaying
    
    for(int i = 0; i < HEIGHT; i++) {
        for(int j = 0; j < WIDTH; j++) {
            if (canvas[i][j] == 'X') {
                printf("X "); // Display a pixel
            } else {
                printf(". "); // Empty space
            }
        }
        printf("\n");
    }
}