//GPT-4o-mini DATASET v1.0 Category: Network Packet Monitoring ; Style: brave
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pcap.h>
#include <arpa/inet.h>

// Define a structure for packet information
struct packet_info {
    struct pcap_pkthdr header;
    const u_char *data;
};

void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    struct packet_info p_info;
    p_info.header = *header;
    p_info.data = packet;

    // Print packet timestamp
    printf("Packet Timestamp: %ld.%ld seconds\n", p_info.header.ts.tv_sec, p_info.header.ts.tv_usec);
    printf("Packet Length: %d bytes\n", p_info.header.len);
    printf("Captured Length: %d bytes\n", p_info.header.caplen);
    
    // EtherType is found at offset 12. Here we'll read 2 bytes for the EtherType
    const u_char *ethernet = p_info.data;
    unsigned short ether_type = ntohs(*(unsigned short *)(ethernet + 12));

    // Print packet type: IPv4, ARP, etc.
    printf("EtherType: %04x\n", ether_type);
    if (ether_type == 0x0800) {
        printf("Protocol: IPv4\n");
    } else if (ether_type == 0x0806) {
        printf("Protocol: ARP\n");
    } else {
        printf("Protocol: Other - %04x\n", ether_type);
    }
    printf("-----------------------------------\n");
}

void start_capture(const char *device) {
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;

    // Open the device for packet capture
    handle = pcap_open_live(device, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", device, errbuf);
        exit(EXIT_FAILURE);
    }
    
    printf("Starting packet capture on device: %s\n", device);

    // Retrieve packets
    pcap_loop(handle, 0, packet_handler, NULL);

    // Close the handle after capturing packets
    pcap_close(handle);
}

int main(int argc, char *argv[]) {
    if (argc != 2) {
        printf("Usage: %s <network-device>\n", argv[0]);
        return EXIT_FAILURE;
    }

    // Capture packets on the provided network device
    start_capture(argv[1]);

    return EXIT_SUCCESS;
}