//GEMINI-pro DATASET v1.0 Category: Networking ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080

int main() {
    int sockfd;  // Socket descriptor
    int newsockfd;  // New socket descriptor for the client
    int len;  // Length of the address structure
    struct sockaddr_in servaddr, cliaddr;  // Server and client address structures
    char buffer[1024];  // Buffer to store the message
    char *hello = "Hello from the server!\n";

    // Creating a socket
    sockfd = socket(AF_INET, SOCK_STREAM, 0);
    if (sockfd == -1) {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Setting up the server address structure
    memset(&servaddr, 0, sizeof(servaddr));
    servaddr.sin_family = AF_INET;
    servaddr.sin_addr.s_addr = htonl(INADDR_ANY);
    servaddr.sin_port = htons(PORT);

    // Binding the socket to the server address
    if (bind(sockfd, (struct sockaddr *) &servaddr,
             sizeof(servaddr)) == -1) {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listening for incoming connections
    if (listen(sockfd, 5) == -1) {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Accepting incoming connections
    len = sizeof(cliaddr);
    newsockfd = accept(sockfd, (struct sockaddr *) &cliaddr,
                       &len);
    if (newsockfd == -1) {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    // Sending a message to the client
    send(newsockfd, hello, strlen(hello), 0);

    // Closing the socket
    close(sockfd);
    close(newsockfd);

    return 0;
}