//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: sophisticated
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Constant macros for weather conditions
#define SUNNY 1
#define PARTLY_CLOUDY 2
#define CLOUDY 3
#define RAIN 4
#define SNOW 5

// Global variables for weather simulation
int current_weather = SUNNY;
int temperature = 20;

// Function prototypes
void update_weather();
void print_weather();

int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Run the weather simulation for a period of time
  for (int i = 0; i < 100; i++) {
    // Update the weather conditions
    update_weather();

    // Print the current weather conditions
    print_weather();
  }

  return 0;
}

void update_weather() {
  // Randomly choose a new weather condition
  int new_weather = rand() % 5 + 1;

  // Update the current weather condition
  current_weather = new_weather;

  // Update the temperature based on the new weather condition
  switch (current_weather) {
  case SUNNY:
    temperature = 20;
    break;
  case PARTLY_CLOUDY:
    temperature = 18;
    break;
  case CLOUDY:
    temperature = 16;
    break;
  case RAIN:
    temperature = 14;
    break;
  case SNOW:
    temperature = 10;
    break;
  }
}

void print_weather() {
  // Print the current weather conditions
  switch (current_weather) {
  case SUNNY:
    printf("The weather is sunny.\n");
    break;
  case PARTLY_CLOUDY:
    printf("The weather is partly cloudy.\n");
    break;
  case CLOUDY:
    printf("The weather is cloudy.\n");
    break;
  case RAIN:
    printf("The weather is rainy.\n");
    break;
  case SNOW:
    printf("The weather is snowy.\n");
    break;
  }

  // Print the current temperature
  printf("The temperature is %d degrees Celsius.\n", temperature);
}