//Falcon-180B DATASET v1.0 Category: Warehouse Management System ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_PRODUCTS 100
#define MAX_PRODUCT_NAME_LENGTH 50
#define MAX_WAREHOUSE_NAME_LENGTH 50

typedef struct {
    char name[MAX_PRODUCT_NAME_LENGTH];
    int quantity;
    int unitPrice;
} Product;

typedef struct {
    char name[MAX_WAREHOUSE_NAME_LENGTH];
    int capacity;
    Product products[MAX_PRODUCTS];
} Warehouse;

Warehouse createWarehouse(char* name, int capacity) {
    Warehouse warehouse = {0};
    strcpy(warehouse.name, name);
    warehouse.capacity = capacity;
    return warehouse;
}

void addProduct(Warehouse* warehouse, Product product) {
    int i;
    for (i = 0; i < warehouse->capacity; i++) {
        if (warehouse->products[i].quantity == 0) {
            strcpy(warehouse->products[i].name, product.name);
            warehouse->products[i].quantity = product.quantity;
            warehouse->products[i].unitPrice = product.unitPrice;
            return;
        }
    }
    printf("Warehouse is full.\n");
}

void removeProduct(Warehouse* warehouse, char* productName) {
    int i;
    for (i = 0; i < warehouse->capacity; i++) {
        if (strcmp(warehouse->products[i].name, productName) == 0) {
            warehouse->products[i].quantity = 0;
            return;
        }
    }
    printf("Product not found.\n");
}

void displayWarehouse(Warehouse warehouse) {
    int i;
    printf("Name: %s\nCapacity: %d\n", warehouse.name, warehouse.capacity);
    printf("Products:\n");
    for (i = 0; i < warehouse.capacity; i++) {
        if (warehouse.products[i].quantity > 0) {
            printf("Name: %s\nQuantity: %d\nUnit Price: $%d\n", warehouse.products[i].name, warehouse.products[i].quantity, warehouse.products[i].unitPrice);
        }
    }
}

int main() {
    Warehouse warehouse = createWarehouse("Main Warehouse", 100);
    addProduct(&warehouse, (Product){"Laptop", 50, 1000});
    addProduct(&warehouse, (Product){"Monitor", 30, 500});
    displayWarehouse(warehouse);
    removeProduct(&warehouse, "Laptop");
    displayWarehouse(warehouse);
    return 0;
}